--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"
require "ISUI/ISLayoutManager"

ISInfoChainsawAction = ISBaseTimedAction:derive("ISInfoChainsawAction")

function ISInfoChainsawAction:isValid()
	return self.chainsaw ~= nil
end

function ISInfoChainsawAction:perform()
	local window = ISChainsawRevolutionInfoWindow.windows[self.character]
	if window then
		window:setObject(self.chainsaw)
	else
		local x = getPlayerScreenLeft(self.playerNum)
		local y = getPlayerScreenTop(self.playerNum)
		local w = getPlayerScreenWidth(self.playerNum)
		local h = getPlayerScreenHeight(self.playerNum)
		window = ISChainsawRevolutionInfoWindow:new(x + 70, y + 50, self.character, self.chainsaw)
		window:initialise()
		window:addToUIManager()
		ISChainsawRevolutionInfoWindow.windows[self.character] = window
		if self.character:getPlayerNum() == 0 then
			ISLayoutManager.RegisterWindow('chainsaw', ISCollapsableWindow, window)
		end
	end
	window:setVisible(true)
	window:addToUIManager()
	local joypadData = JoypadState.players[self.playerNum+1]
	if joypadData then
		joypadData.focus = window
	end
	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function ISInfoChainsawAction:new(character, chainsaw)
	local o = {}
	setmetatable(o, self)
	self.__index = self
	o.maxTime = 0
	o.stopOnWalk = true
	o.stopOnRun = true
	o.character = character
	o.playerNum = character:getPlayerNum()
	o.chainsaw = chainsaw
	return o
end
